﻿using System;
using System.Net.Http;
using System.Net.Http.Headers;
using System.Threading.Tasks;
using VA.PPMS.IWS.Api.Configuration.Interface;
using VA.PPMS.IWS.Api.HttpClientHandler.Interface;
using VA.PPMS.IWS.Common;

namespace VA.PPMS.IWS.Api.HttpClientHandler
{
    public class HttpClientHandler : IHttpClientHandler
    {
        private readonly IIwsConfiguration _configuration;

        public HttpClientHandler(IIwsConfiguration configuration)
        {
            _configuration = configuration;
        }

        public async Task<HttpResponseMessage> PostAsync(string requestUri, string payload, DasMessage dasMessage)
        {
            var client = await GetHttpClient("application/xml", dasMessage);

            return await client.PostAsync(requestUri, new StringContent(payload));
        }

        public async Task<HttpResponseMessage> PostAsync(string requestUri, DasMessage dasMessage)
        {
            var client = await GetHttpClient("application/plain", dasMessage);
            return await client.PostAsync(requestUri, new StringContent(dasMessage.ToString()));
        }

        public async Task<HttpResponseMessage> GetAsync(string queryString)
        {
            var client = await GetHttpClient("application/plain");
            return await client.GetAsync(queryString);
        }

        internal async Task<HttpClient> GetHttpClient(string contentType)
        {
            var client = new HttpClient { BaseAddress = new Uri(await _configuration.GetFunctionBaseUriAsync()) };
            client.DefaultRequestHeaders.Accept.Clear();
            client.DefaultRequestHeaders.Accept.Add(new MediaTypeWithQualityHeaderValue(contentType));

            return client;
        }

        internal async Task<HttpClient> GetHttpClient(string contentType, DasMessage message)
        {
            var client = new HttpClient { BaseAddress = new Uri(await _configuration.GetFunctionBaseUriAsync()) };
            client.DefaultRequestHeaders.Accept.Clear();
            client.DefaultRequestHeaders.Accept.Add(new MediaTypeWithQualityHeaderValue(contentType));
            client.DefaultRequestHeaders.Add("X-ConversationID", message.ConversationId);
            client.DefaultRequestHeaders.Add("X-RoutingSenderID", message.SenderId);
            client.DefaultRequestHeaders.Add("X-RoutingReceiverIDs", message.ReceiverId);
            client.DefaultRequestHeaders.Add("X-TransactionID", message.TransactionId);

            return client;
        }
    }
}